IF EXISTS ( SELECT *
		      FROM SYS.OBJECTS
		     WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[UFD_RC_DEB_CLI_PDV_MOEDAS_XML]')
		)
BEGIN
	DROP FUNCTION [DBO].[UFD_RC_DEB_CLI_PDV_MOEDAS_XML]
END
GO


CREATE FUNCTION [DBO].[UFD_RC_DEB_CLI_PDV_MOEDAS_XML] (@CD_EMP INT,@FILIAL INT,@CD_RC_DEB INT )
RETURNS XML

BEGIN
	DECLARE @RET XML;

	SET @RET = (
				SELECT A.CD_EMP
					  ,A.CD_FILIAL
					  ,A.CD_ORC_PAG
					  ,CAST(A.VLR_PAG AS MONEY) VLR_PAG
					  ,CAST(A.VLR_TROCO AS MONEY) VLR_TROCO
					  ,B.NR_CARTAO
					  ,B.CD_SEGURANCA
					  ,B.VALIDADE
					  ,B.NR_AUTORIZACAO
					  ,B.QTDE_PARC
					  ,B.TRN_POS
					  ,B.NSU
					  ,B.BANDEIRA
				  FROM RC_DEB_PAG A
					   INNER JOIN RC_DEB_PAG_CARTAO B ON A.CD_CTR = B.PAG_CD_CTR
				 WHERE a.CD_EMP    = @CD_EMP
				   AND a.CD_FILIAL = @FILIAL
				   AND a.CD_RC_DEB = @CD_RC_DEB
				FOR XML RAW('MOEDA') ,ELEMENTS
			)

	RETURN @RET
END;
